require("stategraphs/commonstates")


local function startaura(inst)
end



local function stopaura(inst)
end


local events=
{
    CommonHandlers.OnLocomote(true, true),
    EventHandler("attacked", function(inst) if inst.components.health:GetPercent() > 0 then inst.sg:GoToState("hit") end end),
	EventHandler("death", function(inst) inst.sg:GoToState("dissipate") end),
}

local function getidleanim(inst)
    if inst.components.combat.target or inst.components.aura.applying then
        return "angry"
    elseif inst.components.health:GetPercent() < .4 then
        return "shy"
    else
        return "idle"
    end

end

local states=
{
    State
    {
        name = "idle",
        tags = {"idle", "canrotate", "canslide"},
        onenter = function(inst)
            inst.AnimState:PlayAnimation(getidleanim(inst), true)
        end,
    },
    
	
    State{
        name = "open",
        tags = {"busy", "open"},
        
        onenter = function(inst)
            inst.Physics:Stop()
        end,

        events=
        {   
            EventHandler("animover", function(inst) inst.sg:GoToState("open_idle") end ),
        },

        timeline=
        {
        },        
    },

    State{
        name = "open_idle",
        tags = {"busy", "open"},
        
        onenter = function(inst)
        end,

        events=
        {   
            EventHandler("animover", function(inst) inst.sg:GoToState("open_idle") end ),
        },

        timeline=
        {
        },        
    },

    State{
        name = "close",
        tags = {""},
        
        onenter = function(inst)
        end,

        events=
        {   
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end ),
        },

        timeline=
        {
        },        
    },   
    
	
	
	
    State
    {
        name = "appear",
        onenter = function(inst)
            inst.AnimState:PlayAnimation("appear")
            if inst:HasTag("girl") then
            else
            end
        end,
        
        events=
        {
        },
        
    },    
    
    State{
        name = "hit",
        tags = {"busy"},
        
        onenter = function(inst)
            if inst:HasTag("girl") then
            else
            end
                
            inst.AnimState:PlayAnimation("hit")
            inst.Physics:Stop()            
        end,
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end ),
        },
    },

    State
    {
        name = "dissipate",
        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("dissipate")
            if inst:HasTag("girl") then
            else
            end
            
        end,
        
        events=
        {
            EventHandler("animover", function(inst, data) 
                if inst.components.lootdropper then
                    inst.components.lootdropper:DropLoot()
                end
                inst:Remove() end)
        },
    },
   
}


CommonStates.AddSimpleWalkStates(states, getidleanim)
CommonStates.AddSimpleRunStates(states, getidleanim)
    
return StateGraph("ghost", states, events, "appear")

